/*-----------------------------------------------------------------------------------------
 *  This software is in the public domain, furnished "as is", without technical
 *  support, and with no warranty, express or implied, as to its usefulness for
 *  any purpose.
 *
 *  RCReceiver.ino:
 *
 *  ESP32 microcontroller software project to implement collection and validation of 
 *  RC PWM pulse lenght data with the ESP-IDF 5.x development invirement.
 *
 *  This is the main header file for definitions.
 *
 *  Author: Volker Frauenstein
 *  Date: 07/07/2025 Version: 1.1 validPWM added to support new runtime reseve calculation
 *
 *  Date: 02/05/2025 Version: 1.0 new global RC_xxx and MS_xxx definitions added
*/

// global includes of header files to handle input signals from RC  -> esp32 from Espressif Systems version 3.3.6
#include "driver/rmt_rx.h"                                      // needed for RC PWM receive functions

// definitions to handle input signals from RC
volatile bool pwmReadDone = false;                              // semaphore to trigger next loop after new RC Signal read
volatile bool validPWM = false;                                 // semaphore to trigger failsafe if false
volatile int panic = 0;                                         // counter for RC signal cycle errorlevel
volatile int RC_cycle = 0;                                      // monitoring value for RC signal cycle duration

// definitions of functional PwmReceiver output
volatile float RC_Rudder = 0;                                   // RC input for Steering normed from 1 to -1
volatile float RC_MultiSwitch = 0;                              // RC input for Multiswitch normed from 1 to -1
volatile float RC_Channel3 = 0;                                 // RC input for Channel 3 from 1 to -1
volatile float RC_Trottle = 0;                                  // RC input for Trottle normed from 1 to -1

// definitions to handle Multiswitch state
volatile bool switchOn[4] = {false, false, false, false};       // one bit per switch: {MS_Func1, MS_Func2, MS_Func3, MS_Func4}
volatile int last_state = 0;                                    // switch state of last cycle
const int MS_Func1 = 0;                                         // Multiswitch slot for function 1 on/off
const int MS_Func2 = 1;                                         // Multiswitch slot for function 2 on/off
const int MS_Func3 = 2;                                         // Multiswitch slot for function 3 on/off
const int MS_Func4 = 3;                                         // Multiswitch slot for function 4 on/off

// decleration of function prototypes
void setup_Core0(void);                                         // ESP32 core0 functions
void setup_PwmChannels(void);                                   // RC PWM receive functions
bool runPwmReciever (void);
void setup_MultiSwitch(void);                                   // multiswitch functions
void close_MultiSwitch(void);
void run_MultiSwitch(void);
