/*-----------------------------------------------------------------------------------------
 *  This software is in the public domain, furnished "as is", without technical
 *  support, and with no warranty, express or implied, as to its usefulness for
 *  any purpose.
 *
 *  Core0.ino
 *
 *  Setup function for run task on ESP32 core0.
 *
 *  Author: Volker Frauenstein
 *  Date: 10/05/2025 Version: 1.0 migration from other ESP32 projects with dual core functions
 */

void setup_Core0(void) {                                        // function to set up task on core0 (as second main loop)

  TaskHandle_t Core0TaskHnd;                                    // task setup (running on core 0)
  
  xTaskCreatePinnedToCore (                                     // create task for core 0
    TaskCore0,                                                  // task function
    "cpu0",                                                     // name of task
    100000,                                                     // stack size of task (10000)
    NULL,                                                       // supporting parameters of task 
    1,                                                          // priority of the task (1 = low to 5 = highest)
    &Core0TaskHnd,                                              // Task handle 
    0);                                                         // core to run task on
}


